/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.List;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.behaviour.furniture.CraftingStationBehaviour;
import technology.rocketjump.undermount.entities.behaviour.plants.FallingTreeBehaviour;
import technology.rocketjump.undermount.entities.components.FurnitureInventoryComponent;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.jobs.JobStore;
import technology.rocketjump.undermount.jobs.JobWorkCalculator;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.mapping.tile.wall.Wall;
import technology.rocketjump.undermount.messaging.types.ApplyDesignationMessage;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.JobCompletedMessage;
import technology.rocketjump.undermount.messaging.types.RemoveDesignationMessage;
import technology.rocketjump.undermount.rooms.constructions.Construction;

@Singleton
public class JobMessageHandler
implements GameContextAware,
Telegraph,
Disposable {
    private final MessageDispatcher messageDispatcher;
    private final JobWorkCalculator jobWorkCalculator;
    private final JobStore jobStore;
    private final ItemEntityFactory itemEntityFactory;
    private GameContext gameContext;

    @Inject
    public JobMessageHandler(MessageDispatcher messageDispatcher, JobWorkCalculator jobWorkCalculator, JobStore jobStore, ItemEntityFactory itemEntityFactory) {
        this.messageDispatcher = messageDispatcher;
        this.jobWorkCalculator = jobWorkCalculator;
        this.jobStore = jobStore;
        this.itemEntityFactory = itemEntityFactory;
        messageDispatcher.addListener(this, 254);
        messageDispatcher.addListener(this, 255);
        messageDispatcher.addListener(this, 604);
        messageDispatcher.addListener(this, 609);
        messageDispatcher.addListener(this, 603);
        messageDispatcher.addListener(this, 602);
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, 254);
        this.messageDispatcher.removeListener((Telegraph)this, 255);
        this.messageDispatcher.removeListener((Telegraph)this, 604);
        this.messageDispatcher.removeListener((Telegraph)this, 609);
        this.messageDispatcher.removeListener((Telegraph)this, 603);
        this.messageDispatcher.removeListener((Telegraph)this, 602);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 254: {
                return this.handle((ApplyDesignationMessage)msg.extraInfo);
            }
            case 255: {
                return this.handle((RemoveDesignationMessage)msg.extraInfo);
            }
            case 604: {
                return this.handleJobCompleted((JobCompletedMessage)msg.extraInfo);
            }
            case 603: {
                Job acceptedJob = (Job)msg.extraInfo;
                this.jobStore.switchState(acceptedJob, JobState.ASSIGNED);
                return true;
            }
            case 609: {
                Job acceptedJob = (Job)msg.extraInfo;
                this.jobStore.addNewJob(acceptedJob);
                return true;
            }
            case 602: {
                Job cancelledJob = (Job)msg.extraInfo;
                cancelledJob.setAssignedToEntityId(null);
                if (this.jobStore.getAllJobs().containsKey(cancelledJob.getJobId())) {
                    if (cancelledJob.getType().equals((Object)JobType.HAULING)) {
                        this.jobStore.remove(cancelledJob);
                    } else {
                        this.jobStore.switchState(cancelledJob, JobState.ASSIGNABLE);
                    }
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private boolean handleJobCompleted(JobCompletedMessage jobCompletedMessage) {
        MapTile tile;
        Job completedJob = jobCompletedMessage.getJob();
        float skillLevelOfCompletion = jobCompletedMessage.getCompletedBy().getSkillLevel(completedJob.getRequiredProfession());
        switch (completedJob.getType()) {
            case MINING: {
                MapTile targetTile = this.gameContext.getAreaMap().getTile(completedJob.getJobLocation());
                if (targetTile == null || !targetTile.hasWall()) break;
                Wall wall = targetTile.getWall();
                if (wall.hasOre()) {
                    GameMaterial oreMaterial = wall.getOreMaterial();
                    if (this.gameContext.getRandom().nextFloat() < skillLevelOfCompletion + 0.1f) {
                        this.gameContext.getEntityStore().createResourceItem(oreMaterial, completedJob.getJobLocation(), this.gameContext.getAreaMap(), this.gameContext.getRandom(), 1, wall.getMaterial());
                    }
                } else if (this.gameContext.getRandom().nextFloat() < skillLevelOfCompletion) {
                    this.gameContext.getEntityStore().createResourceItem(wall.getMaterial(), completedJob.getJobLocation(), this.gameContext.getAreaMap(), this.gameContext.getRandom(), 1, new GameMaterial[0]);
                }
                this.messageDispatcher.dispatchMessage(606, completedJob.getJobLocation());
                break;
            }
            case LOGGING: {
                MapTile targetTile = this.gameContext.getAreaMap().getTile(completedJob.getJobLocation());
                Entity targetTree = null;
                if (targetTile != null && targetTile.hasTree()) {
                    for (Entity entity : targetTile.getEntities()) {
                        if (!entity.getType().equals((Object)EntityType.PLANT)) continue;
                        targetTree = entity;
                        break;
                    }
                }
                if (targetTree == null) break;
                Vector2 worldPositionOfChoppingEntity = jobCompletedMessage.getCompletedByEntity().getLocationComponent().getWorldPosition();
                boolean fallToWest = true;
                if (worldPositionOfChoppingEntity.x < targetTree.getLocationComponent().getWorldPosition().x) {
                    fallToWest = false;
                }
                FallingTreeBehaviour fallingTreeBehaviour = new FallingTreeBehaviour(fallToWest);
                this.gameContext.getEntityStore().changeBehaviour(targetTree, fallingTreeBehaviour, this.gameContext, this.messageDispatcher);
                break;
            }
            case HAULING: 
            case COLLECT_ITEM: {
                break;
            }
            case CLEAR_GROUND: {
                MapTile targetTile = this.gameContext.getAreaMap().getTile(completedJob.getJobLocation());
                Entity targetPlant = null;
                if (targetTile != null && targetTile.hasShrub()) {
                    for (Entity entity : targetTile.getEntities()) {
                        if (!entity.getType().equals((Object)EntityType.PLANT)) continue;
                        targetPlant = entity;
                        break;
                    }
                }
                if (targetPlant == null) break;
                this.messageDispatcher.dispatchMessage(322, new EntityMessage(targetPlant.getId()));
                break;
            }
            case CONSTRUCT_STONE_FURNITURE: 
            case CONSTRUCT_WOODEN_FURNITURE: {
                MapTile targetTile = this.gameContext.getAreaMap().getTile(completedJob.getJobLocation());
                Construction construction = targetTile.getConstruction();
                this.messageDispatcher.dispatchMessage(807, construction);
                break;
            }
            case CRAFT_AT_WORKSTATION: {
                Entity craftingStationEntity = this.gameContext.getEntityStore().getById(completedJob.getTargetEntityId());
                CraftingStationBehaviour craftingStationBehaviour = (CraftingStationBehaviour)craftingStationEntity.getBehaviourComponent();
                FurnitureInventoryComponent inventoryComponent = craftingStationEntity.getComponent(FurnitureInventoryComponent.class);
                craftingStationBehaviour.jobCompleted(this.itemEntityFactory, this.gameContext);
                break;
            }
            default: {
                System.err.println("Not yet implemented job completion: " + (Object)((Object)completedJob.getType()));
            }
        }
        if (completedJob.getType().isAccessedFromAdjacentTile()) {
            TileNeighbours orthogonalNeighbours = this.gameContext.getAreaMap().getOrthogonalNeighbours(completedJob.getJobLocation().x, completedJob.getJobLocation().y);
            for (MapTile neighbourTile : orthogonalNeighbours.values()) {
                for (Job neighbourJob : this.jobStore.getJobsAtLocation(neighbourTile.getTilePosition())) {
                    if (!neighbourJob.getType().equals((Object)completedJob.getType()) || !neighbourJob.getJobState().equals((Object)JobState.INACCESSIBLE)) continue;
                    this.jobStore.switchState(neighbourJob, JobState.ASSIGNABLE);
                }
            }
        }
        if ((tile = this.gameContext.getAreaMap().getTile(completedJob.getJobLocation())) != null && tile.getDesignation() != null) {
            tile.setDesignation(null);
        }
        this.jobStore.remove(completedJob);
        return true;
    }

    private boolean handle(ApplyDesignationMessage applyDesignationMessage) {
        JobType jobType = applyDesignationMessage.getDesignationToApply().getCreatesJobType();
        if (jobType != null) {
            Job newJob = new Job(jobType);
            newJob.setJobLocation(applyDesignationMessage.getTargetTile().getTilePosition());
            newJob.setTotalWorkToDo(this.jobWorkCalculator.getTotalWorkToDo(jobType, applyDesignationMessage.getTargetTile(), null));
            newJob.setWorkDoneSoFar(0.0f);
            newJob.setJobState(this.calculateNewJobState(jobType, applyDesignationMessage.getTargetTile()));
            this.jobStore.addNewJob(newJob);
        }
        return true;
    }

    private boolean handle(RemoveDesignationMessage removeDesignationMessage) {
        JobType jobType = removeDesignationMessage.getDesignationToRemove().getCreatesJobType();
        if (jobType != null) {
            List<Job> jobsAtLocation = this.jobStore.getJobsAtLocation(removeDesignationMessage.getTargetTile().getTilePosition());
            LinkedList<Job> jobsToRemove = new LinkedList<Job>();
            for (Job job : jobsAtLocation) {
                if (!job.getType().equals((Object)jobType)) continue;
                jobsToRemove.add(job);
            }
            for (Job job : jobsToRemove) {
                if (job.getAssignedToEntityId() != null) {
                    this.messageDispatcher.dispatchMessage(608, new EntityMessage(job.getAssignedToEntityId()));
                }
                this.jobStore.remove(job);
            }
        }
        return true;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }

    private JobState calculateNewJobState(JobType jobType, MapTile targetTile) {
        if (jobType.isAccessedFromAdjacentTile()) {
            boolean neighbourIsAccessible = false;
            TileNeighbours orthogonalNeighbours = this.gameContext.getAreaMap().getOrthogonalNeighbours(targetTile.getTileX(), targetTile.getTileY());
            for (MapTile neighbourTile : orthogonalNeighbours.values()) {
                if (!neighbourTile.isNavigable()) continue;
                neighbourIsAccessible = true;
                break;
            }
            if (neighbourIsAccessible) {
                return JobState.POTENTIALLY_ACCESSIBLE;
            }
            return JobState.INACCESSIBLE;
        }
        if (targetTile.isNavigable()) {
            return JobState.POTENTIALLY_ACCESSIBLE;
        }
        return JobState.INACCESSIBLE;
    }
}

